// OutputTTSDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "OutputTTSDlg.h"
#include "IBFlowView.h"
#include "XISLOutputTTS.h"
#include "XISLVar.h"
#include "XISLVarList.h"
#include "SSMClient.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// COutputTTSDlg _CAO


COutputTTSDlg::COutputTTSDlg(CXISLOutputTTS *pOutputTag,CXISLTag *pCurrentTag,CWnd* pParent /*=NULL*/)
	: CDialog(COutputTTSDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COutputTTSDlg)
	m_strText = _T("");
	m_nEventGlp = -1;
	m_strPitchL = _T("");
	m_strPitchR = _T("");
	m_strPron = _T("");
	m_strRate = _T("");
	m_strVolume = _T("");
	//}}AFX_DATA_INIT
	m_pParent = (CIBFlowView*)pParent;
	m_pOutputTag = pOutputTag;
	m_pCurrentTag = pCurrentTag;
	m_pTextList = NULL;
	m_pSSMClient = NULL;
}


void COutputTTSDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COutputTTSDlg)
	DDX_Control(pDX, IDC_SCHAR_COMBO2, m_cmbCharOpt);
	DDX_Control(pDX, IDC_EDIT_TEXT, m_editText);
	DDX_Control(pDX, IDC_SCHAR_COMBO, m_cmbCharactor);
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Text(pDX, IDC_EDIT_TEXT, m_strText);
	DDX_Radio(pDX, IDC_RADIO_CHARACTOR, m_nEventGlp);
	DDX_Text(pDX, IDC_EDIT_PITCHL, m_strPitchL);
	DDX_Text(pDX, IDC_EDIT_PITCHR, m_strPitchR);
	DDX_Text(pDX, IDC_EDIT_PRON, m_strPron);
	DDX_Text(pDX, IDC_EDIT_RATE, m_strRate);
	DDX_Text(pDX, IDC_EDIT_VOLUME, m_strVolume);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COutputTTSDlg, CDialog)
	//{{AFX_MSG_MAP(COutputTTSDlg)
	ON_BN_CLICKED(IDC_RADIO_CHARACTOR, OnRadioCharactor)
	ON_BN_CLICKED(IDC_RADIO_SPEECH, OnRadioSpeech)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_VAR, OnDblclkListVar)
	ON_BN_CLICKED(IDC_BUTTON_TEST, OnButtonTest)
	ON_BN_CLICKED(IDC_BUTTON_EMPH, OnButtonEmph)
	ON_BN_CLICKED(IDC_BUTTON_PITCHL, OnButtonPitchl)
	ON_BN_CLICKED(IDC_BUTTON_PITCHLR, OnButtonPitchlr)
	ON_BN_CLICKED(IDC_BUTTON_PRON, OnButtonPron)
	ON_BN_CLICKED(IDC_BUTTON_RATE, OnButtonRate)
	ON_BN_CLICKED(IDC_BUTTON_SILENCE, OnButtonSilence)
	ON_BN_CLICKED(IDC_BUTTON_VOICE, OnButtonVoice)
	ON_BN_CLICKED(IDC_BUTTON_VOLUME, OnButtonVolume)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COutputTTSDlg bZ[W nh

BOOL COutputTTSDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbVar.GetClientRect(&rect);
	column.cx = 70;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = (rect.right-rect.left)-70;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	int nType = m_pCurrentTag->m_nTagType;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	int nCount = pExcItem->m_pLocalVar->SetVar2ListBox(m_lbVar);
		
	CXISLDialogTag *pDTag = (CXISLDialogTag*)pExcItem->GetParentDialogTag();
	nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
	
	CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
	nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
	
	if(!pRTag->IsAppRoot() && g_pAppRootTag)
		g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);

	CString strParam;
	if(m_pOutputTag->m_nOutputEvent == ID_TTSEVENT_SPEECH)
	{
		m_nEventGlp = 1;
		m_strText = m_pOutputTag->GetText(strParam);
		UpdateData(FALSE);
		OnRadioSpeech();
	}
	else if(m_pOutputTag->m_nOutputEvent == ID_TTSEVENT_SCHAR)
	{
		m_nEventGlp = 0;
		m_cmbCharactor.SetCurSel(m_cmbCharactor.FindString(-1,SPEECH_CHARACTOR[m_pOutputTag->GetCharactor()]));
		UpdateData(FALSE);
		OnRadioCharactor();
	}
	else
	{
		m_nEventGlp = 0;
		OnRadioCharactor();
	}

	UpdateData(FALSE);
	((CMainFrame*)AfxGetMainWnd())->ConnectIPAEngine(this);

	// c[qgRg[쐬
	 m_ToolTip.Create(this);	
	 // c[qgRg[ nj{^Ɍѕt
	 m_ToolTip.AddTool((CButton *)GetDlgItem(IDOK),	_T("This is OK button")); 

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void COutputTTSDlg::OnRadioCharactor() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_cmbCharactor.EnableWindow();
	m_lbVar.EnableWindow(FALSE);
	m_editText.EnableWindow(FALSE);
}

void COutputTTSDlg::OnRadioSpeech() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_cmbCharactor.EnableWindow(FALSE);
	m_lbVar.EnableWindow();
	m_editText.EnableWindow();
}

void COutputTTSDlg::OnDblclkListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = pNMListView->iItem;
	item.iSubItem = 0;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	if(item.iItem != -1)
	{
		UpdateData();
		int nStart,nEnd;
		m_editText.GetSel(nStart,nEnd);

		if((nStart != 0) && (nStart != m_strText.GetLength()))
		{
			int nSpace1=0,nSpace2=0;
			while(1)
			{
				nSpace1 = m_strText.Find(" $",nSpace1);
				if(nSpace1 == -1)
					break;
				nSpace2 = m_strText.Find(" ",nSpace1+1);
				if(nSpace2 == -1)
					nSpace2 = m_strText.GetLength();

				if(nStart >= nSpace1 && nStart <= nSpace2)
				{
					nStart = nSpace2;
					break;
				}
				nSpace1 = nSpace2;
			}
		}

		CXISLVar *pVar = (CXISLVar*)item.lParam;
		CString strVarName;
		pVar->GetVarNameEx(strVarName);
		strVarName.Insert(0," $");
		strVarName += " ";
		m_strText.Insert(nStart,strVarName);
		UpdateData(FALSE);
	}	
	*pResult = 0;
}

void COutputTTSDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();
	if(m_nEventGlp == 0)
		m_pOutputTag->SetCharactor(m_cmbCharactor.GetCurSel());
	else
	{
//		m_pOutputTag->SetTextParam(m_nSpeed,m_nVolume,!m_bEnglish,!m_bNumber);
		if(!CreateTextList())
			return;
		m_pOutputTag->SetText(m_pTextList);
	}

	CDialog::OnOK();
}

void COutputTTSDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	if(m_pTextList)
	{
		while(!m_pTextList->IsEmpty())
		{
			CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
			if(pVar->IsDummy())
				delete pVar;
		}
	}	
	CDialog::OnCancel();
}

BOOL COutputTTSDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		if(pMsg->wParam == VK_RETURN)
			return TRUE;

		CWnd *pWnd = GetFocus();
		if(pWnd->GetDlgCtrlID() == IDC_EDIT_TEXT)
		{
			UpdateData();
			int nStart,nEnd;
			int nSpace1=0,nSpace2=0;
			switch( pMsg->wParam )
			{
			case VK_DELETE:
				m_editText.GetSel(nStart,nEnd);
				while(1)
				{
					nSpace1 = m_strText.Find(" $",nSpace1);
					if(nSpace1 == -1)
						break;
					nSpace2 = m_strText.Find(" ",nSpace1+1);
					if(nStart >= nSpace1 && nStart <= nSpace2)
					{
						m_strText.Delete(nSpace1,nSpace2-nSpace1);
						UpdateData(FALSE);
						break;
					}
					nSpace1 = nSpace2;
				}
				break;
			case VK_SPACE:
				return TRUE;
			case VK_BACK:
				m_editText.GetSel(nStart,nEnd);
				while(1)
				{
					nSpace1 = m_strText.Find(" $",nSpace1);
					if(nSpace1 == -1)
						break;
					nSpace2 = m_strText.Find(" ",nSpace1+1)+1;
					if(nStart >= nSpace1 && nStart <= nSpace2)
					{
						m_strText.Delete(nSpace1,nSpace2-nSpace1);
						UpdateData(FALSE);
						break;
					}
					nSpace1 = nSpace2;
				}
				break;				
			default:
				break;
			}
		}
	}
	switch(pMsg->message){
	case WM_LBUTTONDOWN:            
	case WM_LBUTTONUP:              
	case WM_MOUSEMOVE:
	    // }EX bZ[Wc[ qg Rg[ɓnď
	    m_ToolTip.RelayEvent(pMsg);
	}

	return CDialog::PreTranslateMessage(pMsg);
}

BOOL COutputTTSDlg::CreateTextList()
{
	UpdateData();

	if(m_pTextList == NULL)
		m_pTextList = new CPtrList;

	m_strText.Replace("@"," ");
	int nStart = 0;
	CXISLVar *pText;
	CString strVarName;
	BOOL bOK = TRUE;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	while(1)
	{
		if(m_strText.IsEmpty())
			break;
		nStart = m_strText.Find(" $",0);
		
		if(nStart == -1)
		{
			pText = new CXISLVar;
			pText->SetAttribute(m_strText,"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			break;
		}

		if(nStart != 0)
		{
			pText = new CXISLVar;
			pText->SetAttribute(m_strText.Left(nStart),"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			m_strText.Delete(0,nStart);
		}
		else
		{
			nStart = m_strText.Find(" ",nStart+1);
			if(nStart == -1)
				strVarName = m_strText;
			else
				strVarName = m_strText.Left(nStart);
			strVarName.Remove('$');
			strVarName.Remove(' ');
			CXISLVar *pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
			if(pVar == NULL)
			{
				AfxMessageBox("݂Ȃϐw肳܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			m_strText.Delete(0,nStart+1);
			m_pTextList->AddTail(pVar);
			pVar->ReferCount(TRUE);
		}
	}

	if(!bOK)
	{
		while(!m_pTextList->IsEmpty())
		{
			CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
			if(pVar->IsDummy())
				delete pVar;
			else
				pVar->ReferCount(FALSE);
		}
	}

	return bOK;
}

void COutputTTSDlg::CheckSel(int &nStart,int &nEnd)
{
	CString strText;
	m_editText.GetWindowText(strText);
	m_editText.GetSel(nStart,nEnd);

	int nDl = strText.Find("$");
	while(nDl != -1)
	{
		int nSp = strText.Find(" ",nDl);
		if(nSp == -1)
			nSp = strText.GetLength();
		if(nDl < nStart && nStart < nSp)
		{
			nStart = nDl-1;
			nEnd = nSp+1;
			break;
		}
		nDl = strText.Find("$",nSp);
	}
}

void COutputTTSDlg::PostNcDestroy() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(m_pTextList)
		delete m_pTextList;

	CDialog::PostNcDestroy();
}


void COutputTTSDlg::OnButtonTest() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();

	if(m_pSSMClient == NULL)
	{
		AfxMessageBox("mFsȂɂ͐ɃGWNKv܂",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		return;
	}

	CString strParam;
	int nStart=0,nEnd;
	switch(m_nEventGlp)
	{
	case 0:
		m_cmbCharactor.GetWindowText(strParam);
		if(strParam.IsEmpty())
			return;
		m_pSSMClient->SetSpeaker(strParam);
		m_pSSMClient->SetText("b҂ύX܂");
		break;
	case 1:
		while(1)
		{
			nStart = m_strText.Find(" $",nStart);
			if(nStart == -1)
				break;
			nEnd = m_strText.Find(" ",nStart+1);
			if(nEnd == -1)
				nEnd = m_strText.GetLength();
			m_strText.Delete(nStart,nEnd-nStart);
			m_strText.Insert(nStart," ϐ");
		}
		m_pSSMClient->SetText(m_strText);
		break;
	}
}

void COutputTTSDlg::OnButtonEmph() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	int nStart,nEnd;
	CheckSel(nStart,nEnd);

	m_strText.Insert(nEnd,"</EMPH>");
	m_strText.Insert(nStart,"<EMPH>");
	UpdateData(FALSE);
}

void COutputTTSDlg::OnButtonPitchl() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	if(m_strPitchL.IsEmpty())
	{
		AfxMessageBox("sb`x͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		GotoDlgCtrl(GetDlgItem(IDC_EDIT_PITCHL));
		return;
	}

	if( atof(m_strPitchL) == 0)
	{
		AfxMessageBox("0傫l͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		m_strPitchL.Empty();
		UpdateData(FALSE);
		return;
	}

	int nStart,nEnd;
	CheckSel(nStart,nEnd);

	m_strText.Insert(nEnd,"</PITCH>");
	CString strPitch;
	strPitch.Format("<PITCH LEVEL=\"%s\">",m_strPitchL);
	m_strText.Insert(nStart,strPitch);
	UpdateData(FALSE);	
}

void COutputTTSDlg::OnButtonPitchlr() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	if(m_strPitchR.IsEmpty())
	{
		AfxMessageBox("sb`W͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		GotoDlgCtrl(GetDlgItem(IDC_EDIT_PITCHR));
		return;
	}

	if( atof(m_strPitchR) == 0)
	{
		AfxMessageBox("0傫l͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		m_strPitchR.Empty();
		UpdateData(FALSE);
		return;
	}

	int nStart,nEnd;
	CheckSel(nStart,nEnd);

	m_strText.Insert(nEnd,"</PITCH>");
	CString strTag;
	strTag.Format("<PITCH RANGE=\"%s\">",m_strPitchR);
	m_strText.Insert(nStart,strTag);
	UpdateData(FALSE);		
}

void COutputTTSDlg::OnButtonPron() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	if(m_strPron.IsEmpty())
	{
		AfxMessageBox("ǂ݂͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		GotoDlgCtrl(GetDlgItem(IDC_EDIT_PRON));
		return;
	}

	int nStart,nEnd;
	CheckSel(nStart,nEnd);

	m_strText.Insert(nEnd,"</PRON>");
	CString strTag;
	strTag.Format("<PRON SYM=\"%s\">",m_strPron);
	m_strText.Insert(nStart,strTag);
	UpdateData(FALSE);	
}

void COutputTTSDlg::OnButtonRate() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	if(m_strRate.IsEmpty())
	{
		AfxMessageBox("[g͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		GotoDlgCtrl(GetDlgItem(IDC_EDIT_RATE));
		return;
	}

	if( atof(m_strRate) == 0)
	{
		AfxMessageBox("0傫l͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		m_strRate.Empty();
		UpdateData(FALSE);
		return;
	}

	int nStart,nEnd;
	CheckSel(nStart,nEnd);

	m_strText.Insert(nEnd,"</RATE>");
	CString strTag;
	strTag.Format("<RATE SPEED=\"%s\">",m_strRate);
	m_strText.Insert(nStart,strTag);
	UpdateData(FALSE);		
}

void COutputTTSDlg::OnButtonSilence() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	int nStart,nEnd;
	CheckSel(nStart,nEnd);

	m_strText.Insert(nStart,"<SILENCE/>");
	UpdateData(FALSE);	
}

void COutputTTSDlg::OnButtonVoice() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	CString strChar;
	m_cmbCharOpt.GetWindowText(strChar);

	if(strChar.IsEmpty())
	{
		AfxMessageBox("LN^w肵Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		GotoDlgCtrl(GetDlgItem(IDC_SCHAR_COMBO));
		return;
	}

	int nStart,nEnd;
	CheckSel(nStart,nEnd);

	m_strText.Insert(nEnd,"</VOICE>");
	CString strTag;
	strTag.Format("<VOICE OPTIONAL=\"%s\">",strChar);
	m_strText.Insert(nStart,strTag);
	UpdateData(FALSE);	
}

void COutputTTSDlg::OnButtonVolume() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	if(m_strVolume.IsEmpty())
	{
		AfxMessageBox("x͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		GotoDlgCtrl(GetDlgItem(IDC_EDIT_VOLUME));
		return;
	}

	if( atof(m_strVolume) == 0)
	{
		AfxMessageBox("0傫l͂Ă",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		m_strVolume.Empty();
		UpdateData(FALSE);
		return;
	}

	int nStart,nEnd;
	CheckSel(nStart,nEnd);

	m_strText.Insert(nEnd,"</VOLUME>");
	CString strTag;
	strTag.Format("<VOLUME LEVEL=\"%s\">",m_strVolume);
	m_strText.Insert(nStart,strTag);
	UpdateData(FALSE);	
}
